package com.xforceplus.ultraman.app.jcmars.controller;


/**
 * 虚拟业务单feign客户端
 *
 * @author ultraman
 * @date 2022-01-25
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmars.entity.VirtualBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-mars")
public interface VirtualBillFeignApi {

  /**
   * 通过id查询虚拟业务单
   * @param  id
   * @return R
   */
  @GetMapping("/virtualBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增虚拟业务单
   * @param virtualBill 虚拟业务单
   * @return R
   */
  @PostMapping("/virtualBill/add")
  public R save(@RequestBody VirtualBill virtualBill);

  /**
   * 修改虚拟业务单
   * @param virtualBill 虚拟业务单
   * @return R
   */
  @PostMapping("/virtualBill/update")
  public R updateById(@RequestBody VirtualBill virtualBill);

  /**
   * 通过id删除虚拟业务单
   * @param  id
   * @return R
   */
  @DeleteMapping("/virtualBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}