package com.xforceplus.ultraman.app.jcmars.controller;


/**
 * 作废业务单关系feign客户端
 *
 * @author ultraman
 * @date 2022-01-19
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmars.entity.InvalidBillRelation;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-mars")
public interface InvalidBillRelationFeignApi {

  /**
   * 通过id查询作废业务单关系
   * @param  id
   * @return R
   */
  @GetMapping("/invalidBillRelation/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增作废业务单关系
   * @param invalidBillRelation 作废业务单关系
   * @return R
   */
  @PostMapping("/invalidBillRelation/add")
  public R save(@RequestBody InvalidBillRelation invalidBillRelation);

  /**
   * 修改作废业务单关系
   * @param invalidBillRelation 作废业务单关系
   * @return R
   */
  @PostMapping("/invalidBillRelation/update")
  public R updateById(@RequestBody InvalidBillRelation invalidBillRelation);

  /**
   * 通过id删除作废业务单关系
   * @param  id
   * @return R
   */
  @DeleteMapping("/invalidBillRelation/del/{id}" )
  public R removeById(@PathVariable Long id);

}