package com.xforceplus.ultraman.app.jcmars.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * billing类型
 * </p>
 *
 * @author ultraman
 * @since 2022-01-25
 */
public enum Fkart {

    _0("0", "ZF2"),
    _1("1", "ZRE"),
    _2("2", "ZG2"),
    _3("3", "ZL2"),
    _4("4", "ZF2"),
    _5("5", "ZG2-Z003");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Fkart(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Fkart fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            default:
                return null;
        }
    }
}
