package com.xforceplus.ultraman.app.jcmars.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 头操作状态
 * </p>
 *
 * @author ultraman
 * @since 2022-01-25
 */
public enum HeadOperateStatus {

    _0("0", "未合并"),
    _1("1", "合并中"),
    _2("2", "已合并"),
    _3("3", "不开票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    HeadOperateStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HeadOperateStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            default:
                return null;
        }
    }
}
