package com.xforceplus.ultraman.app.jcmars.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * PO类型
 * </p>
 *
 * @author ultraman
 * @since 2022-01-25
 */
public enum Soursys {

    _0("0", "Z001"),
    _1("1", "Z003");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Soursys(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Soursys fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
