package com.xforceplus.ultraman.app.jcmars.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 开票类型
 * </p>
 *
 * @author ultraman
 * @since 2022-01-25
 */
public enum Stkzn {

    _0("0", "增值税专用纸质发票"),
    _1("1", "增值税电子普通发票"),
    _2("2", "增值税纸质普票发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Stkzn(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Stkzn fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
