package com.xforceplus.ultraman.app.jcmars.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * billing
 * </p>
 *
 * @author ultraman
 * @since 2022-01-25
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Billing implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 销方公司编码
   */
  private String ccode;
  /**
   * 生产日期
   */
  private String fkdat;
  /**
   * 单据号
   */
  private String billto;
  /**
   * 购方客户名称
   */
  private String name;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 单据标识
   */
  private String uniqueKey;
  /**
   * 单据标识-公式
   */
  private String uniqueKeyFormula;
  /**
   * 编码
   */
  private String lineNumber;
  /**
   * 是否折扣
   */
  private String isDiscount;
  /**
   * SAP折扣合计
   */
  private String outterDiscountWithTax;
  /**
   * 商品不含税单价
   */
  private String unitPrice;
  /**
   * 商品税额
   */
  private String commodityTax;
  /**
   * 折扣税额
   */
  private String outterDiscountTax;
  /**
   * 总税额
   */
  private String taxAmount;
  /**
   * 价税合计
   */
  private String amountPriceAndTax;
  /**
   * 作废状态
   */
  private String isDisabel;
  /**
   * 拆分明细集合
   */
  private String splitBillings;
  /**
   * 销方公司名称
   */
  private String sellerName;
  /**
   * 销方公司税号
   */
  private String sellerTaxNo;
  /**
   * 销方地址及电话
   */
  private String sellerAddress;
  /**
   * 销方银行账号
   */
  private String sellerBankAccount;
  /**
   * 付款方
   */
  private String payerCode;
  /**
   * 购方税号
   */
  private String stceg;
  /**
   * 购方地址及电话
   */
  private String addrAndPhone;
  /**
   * 购方银行名称
   */
  private String bankA;
  /**
   * 购方银行账号
   */
  private String bankInfo;
  /**
   * PO号
   */
  private String purpord;
  /**
   * 发票备注
   */
  private String remark;
  /**
   * billing号
   */
  private String vbeln;
  /**
   * PO类型
   */
  private String soursys;
  /**
   * 会计凭证号
   */
  private String fidoc;
  /**
   * 销售范围
   */
  private String serea;
  /**
   * 交付证明日期
   */
  private String podat;
  /**
   * 开票类型
   */
  private String stkzn;
  /**
   * 客户信息
   */
  private String custInfo;
  /**
   * 商品名称
   */
  private String arktx;
  /**
   * 产品分类
   */
  private String divInfo;
  /**
   * 单位
   */
  private String vrkme;
  /**
   * 规格
   */
  private String pkgInfo;
  /**
   * 数量
   */
  private String fkimg;
  /**
   * 商品不含税金额
   */
  private String cond01;
  /**
   * SAp折扣后不含税金额
   */
  private String newwr;
  /**
   * 税率
   */
  private BigDecimal taxRate;
  /**
   * SAP税额
   */
  private String cond22;
  /**
   * 价外折扣
   */
  private String cond02;
  /**
   * 价外折扣
   */
  private String cond03;
  /**
   * 价外折扣
   */
  private String cond04;
  /**
   * 价外折扣
   */
  private String cond05;
  /**
   * 价外折扣
   */
  private String cond06;
  /**
   * 价外折扣
   */
  private String cond07;
  /**
   * 价外折扣
   */
  private String cond08;
  /**
   * 价外折扣
   */
  private String cond09;
  /**
   * 价外折扣
   */
  private String cond10;
  /**
   * 价外折扣
   */
  private String cond11;
  /**
   * 价外折扣
   */
  private String cond12;
  /**
   * 价外折扣
   */
  private String cond13;
  /**
   * 价外折扣
   */
  private String cond14;
  /**
   * 价外折扣
   */
  private String cond15;
  /**
   * 价外折扣
   */
  private String cond16;
  /**
   * 价外折扣
   */
  private String cond17;
  /**
   * 价外折扣
   */
  private String cond18;
  /**
   * 价外折扣
   */
  private String cond19;
  /**
   * 价外折扣
   */
  private String cond20;
  /**
   * 价外折扣
   */
  private String cond21;
  /**
   * 价外折扣
   */
  private String cond23;
  /**
   * 价外折扣
   */
  private String cond24;
  /**
   * 价外折扣
   */
  private String cond25;
  /**
   * 价外折扣
   */
  private String cond26;
  /**
   * 价外折扣
   */
  private String cond27;
  /**
   * 价外折扣
   */
  private String cond28;
  /**
   * 价外折扣
   */
  private String cond29;
  /**
   * 价外折扣
   */
  private String cond30;
  /**
   * 价外折扣
   */
  private String cond31;
  /**
   * 价外折扣
   */
  private String cond32;
  /**
   * 价外折扣
   */
  private String cond33;
  /**
   * 价外折扣
   */
  private String cond34;
  /**
   * 价外折扣
   */
  private String cond35;
  /**
   * 价外折扣
   */
  private String cond36;
  /**
   * 价外折扣
   */
  private String cond37;
  /**
   * 价外折扣
   */
  private String cond38;
  /**
   * 价外折扣
   */
  private String cond39;
  /**
   * 价外折扣
   */
  private String cond40;
  /**
   * 价外折扣
   */
  private String cond41;
  /**
   * 价外折扣
   */
  private String cond42;
  /**
   * 价外折扣
   */
  private String cond43;
  /**
   * 价外折扣
   */
  private String cond44;
  /**
   * 价外折扣
   */
  private String cond45;
  /**
   * 价外折扣
   */
  private String cond46;
  /**
   * 价外折扣
   */
  private String cond47;
  /**
   * 价外折扣
   */
  private String cond48;
  /**
   * 价外折扣
   */
  private String cond49;
  /**
   * 价外折扣
   */
  private String cond50;
  /**
   * billing类型
   */
  private String fkart;
  /**
   * 单据类型
   */
  private String documentType;
  /**
   * 销方银行名称
   */
  private String sellerBankName;
  /**
   * 行号
   */
  private String posnr;

  /**
   * 对一关联关系 关联对象 virtualBill
   */
  private Long virtualBillMtoBillId;
  /**
   * 对一关联关系 关联对象 billingHead
   */
  private Long billHeadOtmBillId;

  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("ccode", ccode);
      map.put("fkdat", fkdat);
      map.put("billto", billto);
      map.put("name", name);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("uniqueKey", uniqueKey);
      map.put("uniqueKeyFormula", uniqueKeyFormula);
      map.put("lineNumber", lineNumber);
      map.put("isDiscount", isDiscount);
      map.put("outterDiscountWithTax", outterDiscountWithTax);
      map.put("unitPrice", unitPrice);
      map.put("commodityTax", commodityTax);
      map.put("outterDiscountTax", outterDiscountTax);
      map.put("taxAmount", taxAmount);
      map.put("amountPriceAndTax", amountPriceAndTax);
      map.put("isDisabel", isDisabel);
      map.put("splitBillings", splitBillings);
      map.put("sellerName", sellerName);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("payerCode", payerCode);
      map.put("stceg", stceg);
      map.put("addrAndPhone", addrAndPhone);
      map.put("bankA", bankA);
      map.put("bankInfo", bankInfo);
      map.put("purpord", purpord);
      map.put("remark", remark);
      map.put("vbeln", vbeln);
      map.put("soursys", soursys);
      map.put("fidoc", fidoc);
      map.put("serea", serea);
      map.put("podat", podat);
      map.put("stkzn", stkzn);
      map.put("custInfo", custInfo);
      map.put("arktx", arktx);
      map.put("divInfo", divInfo);
      map.put("vrkme", vrkme);
      map.put("pkgInfo", pkgInfo);
      map.put("fkimg", fkimg);
      map.put("cond01", cond01);
      map.put("newwr", newwr);
      map.put("taxRate", taxRate);
      map.put("cond22", cond22);
      map.put("cond02", cond02);
      map.put("cond03", cond03);
      map.put("cond04", cond04);
      map.put("cond05", cond05);
      map.put("cond06", cond06);
      map.put("cond07", cond07);
      map.put("cond08", cond08);
      map.put("cond09", cond09);
      map.put("cond10", cond10);
      map.put("cond11", cond11);
      map.put("cond12", cond12);
      map.put("cond13", cond13);
      map.put("cond14", cond14);
      map.put("cond15", cond15);
      map.put("cond16", cond16);
      map.put("cond17", cond17);
      map.put("cond18", cond18);
      map.put("cond19", cond19);
      map.put("cond20", cond20);
      map.put("cond21", cond21);
      map.put("cond23", cond23);
      map.put("cond24", cond24);
      map.put("cond25", cond25);
      map.put("cond26", cond26);
      map.put("cond27", cond27);
      map.put("cond28", cond28);
      map.put("cond29", cond29);
      map.put("cond30", cond30);
      map.put("cond31", cond31);
      map.put("cond32", cond32);
      map.put("cond33", cond33);
      map.put("cond34", cond34);
      map.put("cond35", cond35);
      map.put("cond36", cond36);
      map.put("cond37", cond37);
      map.put("cond38", cond38);
      map.put("cond39", cond39);
      map.put("cond40", cond40);
      map.put("cond41", cond41);
      map.put("cond42", cond42);
      map.put("cond43", cond43);
      map.put("cond44", cond44);
      map.put("cond45", cond45);
      map.put("cond46", cond46);
      map.put("cond47", cond47);
      map.put("cond48", cond48);
      map.put("cond49", cond49);
      map.put("cond50", cond50);
      map.put("fkart", fkart);
      map.put("documentType", documentType);
      map.put("sellerBankName", sellerBankName);
      map.put("posnr", posnr);

      map.put("virtualBillMtoBill.id", virtualBillMtoBillId);
      map.put("billHeadOtmBill.id", billHeadOtmBillId);
      return map;
  }

  public static Billing fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Billing entity = new Billing();

    if(map.containsKey("ccode")) {
      Object obj = map.get("ccode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fkdat")) {
      Object obj = map.get("fkdat");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFkdat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billto")) {
      Object obj = map.get("billto");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillto((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uniqueKey")) {
      Object obj = map.get("uniqueKey");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUniqueKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uniqueKeyFormula")) {
      Object obj = map.get("uniqueKeyFormula");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUniqueKeyFormula((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineNumber")) {
      Object obj = map.get("lineNumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLineNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDiscount")) {
      Object obj = map.get("isDiscount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOutterDiscountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnitPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commodityTax")) {
      Object obj = map.get("commodityTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCommodityTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountTax")) {
      Object obj = map.get("outterDiscountTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOutterDiscountTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountPriceAndTax")) {
      Object obj = map.get("amountPriceAndTax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAmountPriceAndTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDisabel")) {
      Object obj = map.get("isDisabel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsDisabel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("splitBillings")) {
      Object obj = map.get("splitBillings");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSplitBillings((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payerCode")) {
      Object obj = map.get("payerCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stceg")) {
      Object obj = map.get("stceg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStceg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addrAndPhone")) {
      Object obj = map.get("addrAndPhone");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAddrAndPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankA")) {
      Object obj = map.get("bankA");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankA((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankInfo")) {
      Object obj = map.get("bankInfo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purpord")) {
      Object obj = map.get("purpord");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurpord((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vbeln")) {
      Object obj = map.get("vbeln");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVbeln((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("soursys")) {
      Object obj = map.get("soursys");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSoursys((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fidoc")) {
      Object obj = map.get("fidoc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFidoc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serea")) {
      Object obj = map.get("serea");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSerea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("podat")) {
      Object obj = map.get("podat");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPodat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stkzn")) {
      Object obj = map.get("stkzn");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStkzn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custInfo")) {
      Object obj = map.get("custInfo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("arktx")) {
      Object obj = map.get("arktx");
      if(obj != null) {
        if(obj instanceof String){
          entity.setArktx((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("divInfo")) {
      Object obj = map.get("divInfo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDivInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vrkme")) {
      Object obj = map.get("vrkme");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVrkme((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pkgInfo")) {
      Object obj = map.get("pkgInfo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPkgInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fkimg")) {
      Object obj = map.get("fkimg");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFkimg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond01")) {
      Object obj = map.get("cond01");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond01((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newwr")) {
      Object obj = map.get("newwr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNewwr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cond22")) {
      Object obj = map.get("cond22");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond22((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond02")) {
      Object obj = map.get("cond02");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond02((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond03")) {
      Object obj = map.get("cond03");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond03((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond04")) {
      Object obj = map.get("cond04");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond04((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond05")) {
      Object obj = map.get("cond05");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond05((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond06")) {
      Object obj = map.get("cond06");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond06((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond07")) {
      Object obj = map.get("cond07");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond07((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond08")) {
      Object obj = map.get("cond08");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond08((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond09")) {
      Object obj = map.get("cond09");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond09((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond10")) {
      Object obj = map.get("cond10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond11")) {
      Object obj = map.get("cond11");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond12")) {
      Object obj = map.get("cond12");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond13")) {
      Object obj = map.get("cond13");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond14")) {
      Object obj = map.get("cond14");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond15")) {
      Object obj = map.get("cond15");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond16")) {
      Object obj = map.get("cond16");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond17")) {
      Object obj = map.get("cond17");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond18")) {
      Object obj = map.get("cond18");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond19")) {
      Object obj = map.get("cond19");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond20")) {
      Object obj = map.get("cond20");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond20((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond21")) {
      Object obj = map.get("cond21");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond21((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond23")) {
      Object obj = map.get("cond23");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond23((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond24")) {
      Object obj = map.get("cond24");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond24((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond25")) {
      Object obj = map.get("cond25");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond25((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond26")) {
      Object obj = map.get("cond26");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond26((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond27")) {
      Object obj = map.get("cond27");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond27((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond28")) {
      Object obj = map.get("cond28");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond28((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond29")) {
      Object obj = map.get("cond29");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond29((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond30")) {
      Object obj = map.get("cond30");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond30((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond31")) {
      Object obj = map.get("cond31");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond31((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond32")) {
      Object obj = map.get("cond32");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond32((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond33")) {
      Object obj = map.get("cond33");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond33((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond34")) {
      Object obj = map.get("cond34");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond34((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond35")) {
      Object obj = map.get("cond35");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond35((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond36")) {
      Object obj = map.get("cond36");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond36((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond37")) {
      Object obj = map.get("cond37");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond37((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond38")) {
      Object obj = map.get("cond38");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond38((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond39")) {
      Object obj = map.get("cond39");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond39((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond40")) {
      Object obj = map.get("cond40");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond40((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond41")) {
      Object obj = map.get("cond41");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond41((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond42")) {
      Object obj = map.get("cond42");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond42((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond43")) {
      Object obj = map.get("cond43");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond43((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond44")) {
      Object obj = map.get("cond44");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond44((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond45")) {
      Object obj = map.get("cond45");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond45((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond46")) {
      Object obj = map.get("cond46");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond46((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond47")) {
      Object obj = map.get("cond47");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond47((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond48")) {
      Object obj = map.get("cond48");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond48((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond49")) {
      Object obj = map.get("cond49");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond49((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond50")) {
      Object obj = map.get("cond50");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCond50((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fkart")) {
      Object obj = map.get("fkart");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFkart((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("posnr")) {
      Object obj = map.get("posnr");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPosnr((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("virtualBillMtoBill.id")) {
      Object obj = map.get("virtualBillMtoBill.id");
      if(obj instanceof Long) {
        entity.setVirtualBillMtoBillId((Long)obj);
      } else if(obj instanceof String) {
        entity.setVirtualBillMtoBillId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("billHeadOtmBill.id")) {
      Object obj = map.get("billHeadOtmBill.id");
      if(obj instanceof Long) {
        entity.setBillHeadOtmBillId((Long)obj);
      } else if(obj instanceof String) {
        entity.setBillHeadOtmBillId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("ccode")) {
      Object obj = map.get("ccode");
      if(obj != null) {
        if(obj instanceof String){
            this.setCcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fkdat")) {
      Object obj = map.get("fkdat");
      if(obj != null) {
        if(obj instanceof String){
            this.setFkdat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billto")) {
      Object obj = map.get("billto");
      if(obj != null) {
        if(obj instanceof String){
            this.setBillto((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String){
            this.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uniqueKey")) {
      Object obj = map.get("uniqueKey");
      if(obj != null) {
        if(obj instanceof String){
            this.setUniqueKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("uniqueKeyFormula")) {
      Object obj = map.get("uniqueKeyFormula");
      if(obj != null) {
        if(obj instanceof String){
            this.setUniqueKeyFormula((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineNumber")) {
      Object obj = map.get("lineNumber");
      if(obj != null) {
        if(obj instanceof String){
            this.setLineNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDiscount")) {
      Object obj = map.get("isDiscount");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setOutterDiscountWithTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitPrice")) {
      Object obj = map.get("unitPrice");
      if(obj != null) {
        if(obj instanceof String){
            this.setUnitPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commodityTax")) {
      Object obj = map.get("commodityTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setCommodityTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountTax")) {
      Object obj = map.get("outterDiscountTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setOutterDiscountTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountPriceAndTax")) {
      Object obj = map.get("amountPriceAndTax");
      if(obj != null) {
        if(obj instanceof String){
            this.setAmountPriceAndTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isDisabel")) {
      Object obj = map.get("isDisabel");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsDisabel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("splitBillings")) {
      Object obj = map.get("splitBillings");
      if(obj != null) {
        if(obj instanceof String){
            this.setSplitBillings((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payerCode")) {
      Object obj = map.get("payerCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setPayerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stceg")) {
      Object obj = map.get("stceg");
      if(obj != null) {
        if(obj instanceof String){
            this.setStceg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("addrAndPhone")) {
      Object obj = map.get("addrAndPhone");
      if(obj != null) {
        if(obj instanceof String){
            this.setAddrAndPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankA")) {
      Object obj = map.get("bankA");
      if(obj != null) {
        if(obj instanceof String){
            this.setBankA((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankInfo")) {
      Object obj = map.get("bankInfo");
      if(obj != null) {
        if(obj instanceof String){
            this.setBankInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purpord")) {
      Object obj = map.get("purpord");
      if(obj != null) {
        if(obj instanceof String){
            this.setPurpord((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vbeln")) {
      Object obj = map.get("vbeln");
      if(obj != null) {
        if(obj instanceof String){
            this.setVbeln((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("soursys")) {
      Object obj = map.get("soursys");
      if(obj != null) {
        if(obj instanceof String){
            this.setSoursys((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fidoc")) {
      Object obj = map.get("fidoc");
      if(obj != null) {
        if(obj instanceof String){
            this.setFidoc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serea")) {
      Object obj = map.get("serea");
      if(obj != null) {
        if(obj instanceof String){
            this.setSerea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("podat")) {
      Object obj = map.get("podat");
      if(obj != null) {
        if(obj instanceof String){
            this.setPodat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("stkzn")) {
      Object obj = map.get("stkzn");
      if(obj != null) {
        if(obj instanceof String){
            this.setStkzn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("custInfo")) {
      Object obj = map.get("custInfo");
      if(obj != null) {
        if(obj instanceof String){
            this.setCustInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("arktx")) {
      Object obj = map.get("arktx");
      if(obj != null) {
        if(obj instanceof String){
            this.setArktx((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("divInfo")) {
      Object obj = map.get("divInfo");
      if(obj != null) {
        if(obj instanceof String){
            this.setDivInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vrkme")) {
      Object obj = map.get("vrkme");
      if(obj != null) {
        if(obj instanceof String){
            this.setVrkme((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pkgInfo")) {
      Object obj = map.get("pkgInfo");
      if(obj != null) {
        if(obj instanceof String){
            this.setPkgInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fkimg")) {
      Object obj = map.get("fkimg");
      if(obj != null) {
        if(obj instanceof String){
            this.setFkimg((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond01")) {
      Object obj = map.get("cond01");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond01((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("newwr")) {
      Object obj = map.get("newwr");
      if(obj != null) {
        if(obj instanceof String){
            this.setNewwr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cond22")) {
      Object obj = map.get("cond22");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond22((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond02")) {
      Object obj = map.get("cond02");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond02((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond03")) {
      Object obj = map.get("cond03");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond03((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond04")) {
      Object obj = map.get("cond04");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond04((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond05")) {
      Object obj = map.get("cond05");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond05((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond06")) {
      Object obj = map.get("cond06");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond06((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond07")) {
      Object obj = map.get("cond07");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond07((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond08")) {
      Object obj = map.get("cond08");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond08((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond09")) {
      Object obj = map.get("cond09");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond09((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond10")) {
      Object obj = map.get("cond10");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond11")) {
      Object obj = map.get("cond11");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond11((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond12")) {
      Object obj = map.get("cond12");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond12((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond13")) {
      Object obj = map.get("cond13");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond13((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond14")) {
      Object obj = map.get("cond14");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond14((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond15")) {
      Object obj = map.get("cond15");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond15((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond16")) {
      Object obj = map.get("cond16");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond16((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond17")) {
      Object obj = map.get("cond17");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond17((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond18")) {
      Object obj = map.get("cond18");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond18((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond19")) {
      Object obj = map.get("cond19");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond19((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond20")) {
      Object obj = map.get("cond20");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond20((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond21")) {
      Object obj = map.get("cond21");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond21((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond23")) {
      Object obj = map.get("cond23");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond23((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond24")) {
      Object obj = map.get("cond24");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond24((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond25")) {
      Object obj = map.get("cond25");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond25((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond26")) {
      Object obj = map.get("cond26");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond26((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond27")) {
      Object obj = map.get("cond27");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond27((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond28")) {
      Object obj = map.get("cond28");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond28((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond29")) {
      Object obj = map.get("cond29");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond29((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond30")) {
      Object obj = map.get("cond30");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond30((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond31")) {
      Object obj = map.get("cond31");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond31((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond32")) {
      Object obj = map.get("cond32");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond32((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond33")) {
      Object obj = map.get("cond33");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond33((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond34")) {
      Object obj = map.get("cond34");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond34((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond35")) {
      Object obj = map.get("cond35");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond35((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond36")) {
      Object obj = map.get("cond36");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond36((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond37")) {
      Object obj = map.get("cond37");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond37((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond38")) {
      Object obj = map.get("cond38");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond38((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond39")) {
      Object obj = map.get("cond39");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond39((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond40")) {
      Object obj = map.get("cond40");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond40((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond41")) {
      Object obj = map.get("cond41");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond41((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond42")) {
      Object obj = map.get("cond42");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond42((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond43")) {
      Object obj = map.get("cond43");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond43((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond44")) {
      Object obj = map.get("cond44");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond44((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond45")) {
      Object obj = map.get("cond45");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond45((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond46")) {
      Object obj = map.get("cond46");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond46((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond47")) {
      Object obj = map.get("cond47");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond47((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond48")) {
      Object obj = map.get("cond48");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond48((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond49")) {
      Object obj = map.get("cond49");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond49((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cond50")) {
      Object obj = map.get("cond50");
      if(obj != null) {
        if(obj instanceof String){
            this.setCond50((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fkart")) {
      Object obj = map.get("fkart");
      if(obj != null) {
        if(obj instanceof String){
            this.setFkart((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String){
            this.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String){
            this.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("posnr")) {
      Object obj = map.get("posnr");
      if(obj != null) {
        if(obj instanceof String){
            this.setPosnr((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("virtualBillMtoBill.id")) {
      Object obj = map.get("virtualBillMtoBill.id");
      if(obj instanceof Long) {
        this.setVirtualBillMtoBillId((Long)obj);
      } else if(obj instanceof String) {
        this.setVirtualBillMtoBillId(Long.parseLong((String)obj));
      }
    }
    if(map.containsKey("billHeadOtmBill.id")) {
      Object obj = map.get("billHeadOtmBill.id");
      if(obj instanceof Long) {
        this.setBillHeadOtmBillId((Long)obj);
      } else if(obj instanceof String) {
        this.setBillHeadOtmBillId(Long.parseLong((String)obj));
      }
    }
  }
}
