package com.xforceplus.ultraman.app.jcmeiyijia.controller;


/**
 * 商品信息管理feign客户端
 *
 * @author ultraman
 * @date 2021-10-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmeiyijia.entity.GoodsMain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-meiyijia")
public interface GoodsMainFeignApi {

  /**
   * 通过id查询商品信息管理
   * @param  id
   * @return R
   */
  @GetMapping("/goodsMain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增商品信息管理
   * @param goodsMain 商品信息管理
   * @return R
   */
  @PostMapping("/goodsMain/add")
  public R save(@RequestBody GoodsMain goodsMain);

  /**
   * 修改商品信息管理
   * @param goodsMain 商品信息管理
   * @return R
   */
  @PostMapping("/goodsMain/update")
  public R updateById(@RequestBody GoodsMain goodsMain);

  /**
   * 通过id删除商品信息管理
   * @param  id
   * @return R
   */
  @DeleteMapping("/goodsMain/del/{id}" )
  public R removeById(@PathVariable Long id);

}