package com.xforceplus.ultraman.app.jcmeiyijia.controller;


/**
 * 供应商管理feign客户端
 *
 * @author ultraman
 * @date 2021-10-18
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmeiyijia.entity.Supplier;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-meiyijia")
public interface SupplierFeignApi {

  /**
   * 通过id查询供应商管理
   * @param  id
   * @return R
   */
  @GetMapping("/supplier/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增供应商管理
   * @param supplier 供应商管理
   * @return R
   */
  @PostMapping("/supplier/add")
  public R save(@RequestBody Supplier supplier);

  /**
   * 修改供应商管理
   * @param supplier 供应商管理
   * @return R
   */
  @PostMapping("/supplier/update")
  public R updateById(@RequestBody Supplier supplier);

  /**
   * 通过id删除供应商管理
   * @param  id
   * @return R
   */
  @DeleteMapping("/supplier/del/{id}" )
  public R removeById(@PathVariable Long id);

}