package com.xforceplus.ultraman.app.jcmeiyijia.controller;


/**
 * 业务规则管理feign客户端
 *
 * @author ultraman
 * @date 2021-11-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmeiyijia.entity.BizRule;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-meiyijia")
public interface BizRuleFeignApi {

  /**
   * 通过id查询业务规则管理
   * @param  id
   * @return R
   */
  @GetMapping("/bizRule/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务规则管理
   * @param bizRule 业务规则管理
   * @return R
   */
  @PostMapping("/bizRule/add")
  public R save(@RequestBody BizRule bizRule);

  /**
   * 修改业务规则管理
   * @param bizRule 业务规则管理
   * @return R
   */
  @PostMapping("/bizRule/update")
  public R updateById(@RequestBody BizRule bizRule);

  /**
   * 通过id删除业务规则管理
   * @param  id
   * @return R
   */
  @DeleteMapping("/bizRule/del/{id}" )
  public R removeById(@PathVariable Long id);

}