package com.xforceplus.ultraman.app.jcmeiyijia.controller;


/**
 * 商品明细修改日志管理feign客户端
 *
 * @author ultraman
 * @date 2021-11-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmeiyijia.entity.GoodsLog;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-meiyijia")
public interface GoodsLogFeignApi {

  /**
   * 通过id查询商品明细修改日志管理
   * @param  id
   * @return R
   */
  @GetMapping("/goodsLog/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增商品明细修改日志管理
   * @param goodsLog 商品明细修改日志管理
   * @return R
   */
  @PostMapping("/goodsLog/add")
  public R save(@RequestBody GoodsLog goodsLog);

  /**
   * 修改商品明细修改日志管理
   * @param goodsLog 商品明细修改日志管理
   * @return R
   */
  @PostMapping("/goodsLog/update")
  public R updateById(@RequestBody GoodsLog goodsLog);

  /**
   * 通过id删除商品明细修改日志管理
   * @param  id
   * @return R
   */
  @DeleteMapping("/goodsLog/del/{id}" )
  public R removeById(@PathVariable Long id);

}