package com.xforceplus.ultraman.app.jcmeiyijia.controller;


/**
 * 付款状态变更feign客户端
 *
 * @author ultraman
 * @date 2021-11-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmeiyijia.entity.PaymentStatusChange;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-meiyijia")
public interface PaymentStatusChangeFeignApi {

  /**
   * 通过id查询付款状态变更
   * @param  id
   * @return R
   */
  @GetMapping("/paymentStatusChange/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增付款状态变更
   * @param paymentStatusChange 付款状态变更
   * @return R
   */
  @PostMapping("/paymentStatusChange/add")
  public R save(@RequestBody PaymentStatusChange paymentStatusChange);

  /**
   * 修改付款状态变更
   * @param paymentStatusChange 付款状态变更
   * @return R
   */
  @PostMapping("/paymentStatusChange/update")
  public R updateById(@RequestBody PaymentStatusChange paymentStatusChange);

  /**
   * 通过id删除付款状态变更
   * @param  id
   * @return R
   */
  @DeleteMapping("/paymentStatusChange/del/{id}" )
  public R removeById(@PathVariable Long id);

}