package com.xforceplus.ultraman.app.jcmeiyijia.controller;


/**
 * 业务单主信息feign客户端
 *
 * @author ultraman
 * @date 2021-11-05
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmeiyijia.entity.SalesBillMain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-meiyijia")
public interface SalesBillMainFeignApi {

  /**
   * 通过id查询业务单主信息
   * @param  id
   * @return R
   */
  @GetMapping("/salesBillMain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增业务单主信息
   * @param salesBillMain 业务单主信息
   * @return R
   */
  @PostMapping("/salesBillMain/add")
  public R save(@RequestBody SalesBillMain salesBillMain);

  /**
   * 修改业务单主信息
   * @param salesBillMain 业务单主信息
   * @return R
   */
  @PostMapping("/salesBillMain/update")
  public R updateById(@RequestBody SalesBillMain salesBillMain);

  /**
   * 通过id删除业务单主信息
   * @param  id
   * @return R
   */
  @DeleteMapping("/salesBillMain/del/{id}" )
  public R removeById(@PathVariable Long id);

}