package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 认证中台-发票勾选状态
 * </p>
 *
 * @author ultraman
 * @since 2022-01-26
 */
public enum CheckStatus {

    _0("0", "默认"),
    _1("1", "勾选中"),
    _2("2", "撤销勾选中"),
    _3("3", "勾选失败"),
    _4("4", "撤销勾选失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CheckStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
