package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单处理状态
 * </p>
 *
 * @author ultraman
 * @since 2022-01-26
 */
public enum ProcessStatus {

    _1("1", "导入成功"),
    _2("2", "已开票"),
    _3("3", "已删除"),
    _4("4", "已作废"),
    _5("5", "作废失败"),
    __2("-2", "待处理"),
    __1("-1", "导入失败"),
    _0("0", "已上传,未反馈"),
    _6("6", "开具失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProcessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProcessStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "-2":
                return __2;
            case "-1":
                return __1;
            case "0":
                return _0;
            case "6":
                return _6;
            default:
                return null;
        }
    }
}
