package com.xforceplus.ultraman.app.jcmeiyijia.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_auth
 * </p>
 *
 * @author ultraman
 * @since 2022-01-26
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceAuth implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 税款所属期
   */
  private String taxPeriod;
  /**
   * 租户编号
   */
  private String tenantNo;
  /**
   * 配置码，固定值：EL
   */
  private String xcode;
  /**
   * 上传结果回写地址
   */
  private String callbackUrl;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 勾选状态
   */
  private String authStatus;
  /**
   * 认证业务日期
   */
  private String authBussiDate;
  /**
   * 认证操作人姓名
   */
  private String authRequestUserName;
  /**
   * 有效税额
   */
  private BigDecimal effectiveTaxAmount;
  /**
   * 勾选成功时间
   */
  private String checkTime;
  /**
   * 认证备注
   */
  private String authRemark;
  /**
   * 消息描述
   */
  private String message;
  /**
   * 状态码
   */
  private String code;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 认证用途
   */
  private String authUse;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("taxPeriod", taxPeriod);
      map.put("tenantNo", tenantNo);
      map.put("xcode", xcode);
      map.put("callbackUrl", callbackUrl);
      map.put("invoiceType", invoiceType);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("authStatus", authStatus);
      map.put("authBussiDate", authBussiDate);
      map.put("authRequestUserName", authRequestUserName);
      map.put("effectiveTaxAmount", effectiveTaxAmount);
      map.put("checkTime", checkTime);
      map.put("authRemark", authRemark);
      map.put("message", message);
      map.put("code", code);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("authUse", authUse);

      return map;
  }

  public static InvoiceAuth fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceAuth entity = new InvoiceAuth();

    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPeriod")) {
      Object obj = map.get("taxPeriod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantNo")) {
      Object obj = map.get("tenantNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xcode")) {
      Object obj = map.get("xcode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setXcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("callbackUrl")) {
      Object obj = map.get("callbackUrl");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCallbackUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authBussiDate")) {
      Object obj = map.get("authBussiDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthBussiDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authRequestUserName")) {
      Object obj = map.get("authRequestUserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthRequestUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("effectiveTaxAmount")) {
      Object obj = map.get("effectiveTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("checkTime")) {
      Object obj = map.get("checkTime");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authRemark")) {
      Object obj = map.get("authRemark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("message")) {
      Object obj = map.get("message");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("code")) {
      Object obj = map.get("code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authUse")) {
      Object obj = map.get("authUse");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthUse((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxPeriod")) {
      Object obj = map.get("taxPeriod");
      if(obj != null) {
        if(obj instanceof String){
            this.setTaxPeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenantNo")) {
      Object obj = map.get("tenantNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xcode")) {
      Object obj = map.get("xcode");
      if(obj != null) {
        if(obj instanceof String){
            this.setXcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("callbackUrl")) {
      Object obj = map.get("callbackUrl");
      if(obj != null) {
        if(obj instanceof String){
            this.setCallbackUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authBussiDate")) {
      Object obj = map.get("authBussiDate");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthBussiDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authRequestUserName")) {
      Object obj = map.get("authRequestUserName");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthRequestUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("effectiveTaxAmount")) {
      Object obj = map.get("effectiveTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setEffectiveTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setEffectiveTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setEffectiveTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
            this.setEffectiveTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setEffectiveTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("checkTime")) {
      Object obj = map.get("checkTime");
      if(obj != null) {
        if(obj instanceof String){
            this.setCheckTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authRemark")) {
      Object obj = map.get("authRemark");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("message")) {
      Object obj = map.get("message");
      if(obj != null) {
        if(obj instanceof String){
            this.setMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("code")) {
      Object obj = map.get("code");
      if(obj != null) {
        if(obj instanceof String){
            this.setCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authUse")) {
      Object obj = map.get("authUse");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthUse((String)obj);
        }
      } else{
      }
    }
  }
}
