package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 调用状态
 * </p>
 *
 * @author ultraman
 * @since 2022-12-21
 */
public enum ApiRequestStatus {

    _1("1", "成功"),
    _2("2", "失败"),
    _0("0", "默认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApiRequestStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApiRequestStatus fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            case "0":
                return _0;
            default:
                return null;
        }
    }
}
