package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 商品审核状态
 * </p>
 *
 * @author ultraman
 * @since 2022-12-21
 */
public enum GoodsApplyStatus {

    _0("0", "初始化"),
    _1("1", "待审核"),
    _2("2", "已驳回"),
    _3("3", "已审核"),
    _4("4", "自动审核");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    GoodsApplyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static GoodsApplyStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
