package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票来源
 * </p>
 *
 * @author ultraman
 * @since 2022-12-21
 */
public enum TaxInvoiceSource {

    QD("qd", "全电发票"),
    SK("sk", "税控发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxInvoiceSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxInvoiceSource fromCode(String code){
        switch(code) {
            case "qd":
                return QD;
            case "sk":
                return SK;
            default:
                return null;
        }
    }
}
