package com.xforceplus.ultraman.app.jcmeiyijia.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * invoice_main
 * </p>
 *
 * @author ultraman
 * @since 2022-12-21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class InvoiceMain implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 发票类型
   */
  private String invoiceType;
  /**
   * 发票号码
   */
  private String invoiceNo;
  /**
   * 发票代码
   */
  private String invoiceCode;
  /**
   * 销方编号
   */
  private String sellerNo;
  /**
   * 销方税号
   */
  private String sellerTaxNo;
  /**
   * 销方地址电话
   */
  private String sellerAddrTel;
  /**
   * 销方地址
   */
  private String sellerAddress;
  /**
   * 销方电话
   */
  private String sellerTel;
  /**
   * 销方银行名称
   */
  private String sellerBankName;
  /**
   * 销方银行账号
   */
  private String sellerBankAccount;
  /**
   * 购方税号
   */
  private String purchaserTaxNo;
  /**
   * 购方名称
   */
  private String purchaserName;
  /**
   * 购方地址
   */
  private String purchaserAddress;
  /**
   * 购方电话
   */
  private String purchaserTel;
  /**
   * 购方银行名称
   */
  private String purchaserBankName;
  /**
   * 购方银行账号
   */
  private String purchaserBankAccount;
  /**
   * 不含税金额
   */
  private BigDecimal amountWithoutTax;
  /**
   * 税额
   */
  private BigDecimal taxAmount;
  /**
   * 含税金额
   */
  private BigDecimal amountWithTax;
  /**
   * 税率
   */
  private String taxRate;
  /**
   * 开票日期
   */
  private Long paperDrewDate;
  /**
   * 备注
   */
  private String remark;
  /**
   * 收款人姓名
   */
  private String cashierName;
  /**
   * 复核人姓名
   */
  private String checkerName;
  /**
   * 开票人姓名
   */
  private String invoicerName;
  /**
   * 发票状态
   */
  private String status;
  /**
   * 原发票号码
   */
  private String originInvoiceNo;
  /**
   * 原发票代码
   */
  private String originInvoiceCode;
  /**
   * 红字信息表编号
   */
  private String redNotificationNo;
  /**
   * 密文
   */
  private String cipherText;
  /**
   * 系统来源
   */
  private String systemOrig;
  /**
   * 邮箱
   */
  private String receiveUserEmail;
  /**
   * 购方银行名称
   */
  private String purchaserBankNameAccount;
  /**
   * 勾选状态
   */
  private String authStatus;
  /**
   * 红冲状态
   */
  private String redStatus;
  /**
   * 红冲时间
   */
  private String redTime;
  /**
   * 红冲人姓名
   */
  private String redUserName;
  /**
   * 退票状态
   */
  private String retreatStatus;
  /**
   * 退票操作时间
   */
  private String retreatTime;
  /**
   * 查验状态
   */
  private String veriStatus;
  /**
   * 查验人
   */
  private String veriUserName;
  /**
   * 冻结状态
   */
  private String freezeStatus;
  /**
   * 冻结操作时间
   */
  private String freezeTime;
  /**
   * 冻结操作人姓名
   */
  private String freezeUserName;
  /**
   * 拓展字段1
   */
  private String ext1;
  /**
   * 拓展字段2
   */
  private String ext2;
  /**
   * 拓展字段3
   */
  private String ext3;
  /**
   * 发票来源 0-默认 11-销方直连 12-销方抽取 13-销方手工回填 21-国税验真 22-国税底账 31-影像识别
   */
  private String invoiceOrig;
  /**
   * 销方公司
   */
  private String sellerName;
  /**
   * 识别状态
   */
  private String recogStatus;
  /**
   * 销方开具状态
   */
  private String sellerSyncStatus;
  /**
   * PDF地址
   */
  private String pdfUrl;
  /**
   * 业务单号
   */
  private String bussinessNo;
  /**
   * 校验码
   */
  private String checkCode;
  /**
   * 购方编号
   */
  private String purchaserNo;
  /**
   * 发票匹配状态
   */
  private String matchStatus;
  /**
   * 发票匹配操作时间
   */
  private String matchTime;
  /**
   * 匹配金额
   */
  private BigDecimal matchAmount;
  /**
   * 扫描抵扣联影像地址
   */
  private String recogDeductionImageUrl;
  /**
   * 扫描发票联影像地址
   */
  private String recogInvoiceImageUrl;
  /**
   * 记账联
   */
  private String recogChargeImageUrl;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 发票ID
   */
  private Long invoiceId;
  /**
   * 锁定状态
   */
  private String lockStatus;
  /**
   * 底账勾选状态
   */
  private String authSyncStatus;
  /**
   * 底帐获取时间，格式yyyy-MM-dd HH:mm:ss
   */
  private String authSyncTime;
  /**
   * 认证中台-发票勾选状态
   */
  private String checkStatus;
  /**
   * 认证中台-勾选发起时间
   */
  private String checkingTime;
  /**
   * 认证中台-勾选失败原因
   */
  private String checkFailureMessage;
  /**
   * 勾选推送状态
   */
  private String checkPush;
  /**
   * 发票来源
   */
  private String invoiceOrigin;
  /**
   * 发票颜色
   */
  private String invoiceColor;
  /**
   * 红冲状态
   */
  private String redFlag;
  /**
   * 是否推送协同
   */
  private String coopIsPush;
  /**
   * 发票来源
   */
  private String taxInvoiceSource;
  /**
   * 全电发票号码
   */
  private String allElectricInvoiceNo;
  /**
   * 全电发票xml链接
   */
  private String xmlUrl;
  /**
   * ofd格式文件链接
   */
  private String ofdUrl;
  /**
   * 图片格式文件链接
   */
  private String imgUrl;
  /**
   * 全电发票qrCode链接
   */
  private String qrCodeUrl;
  /**
   * 国税二维码链接
   */
  private String cipherTextTwoCode;
  /**
   * 图片格式文件链接
   */
  private String imageUrl;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("invoiceType", invoiceType);
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("sellerNo", sellerNo);
      map.put("sellerTaxNo", sellerTaxNo);
      map.put("sellerAddrTel", sellerAddrTel);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("sellerBankName", sellerBankName);
      map.put("sellerBankAccount", sellerBankAccount);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserName", purchaserName);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("amountWithTax", amountWithTax);
      map.put("taxRate", taxRate);
      map.put("paperDrewDate", paperDrewDate);
      map.put("remark", remark);
      map.put("cashierName", cashierName);
      map.put("checkerName", checkerName);
      map.put("invoicerName", invoicerName);
      map.put("status", status);
      map.put("originInvoiceNo", originInvoiceNo);
      map.put("originInvoiceCode", originInvoiceCode);
      map.put("redNotificationNo", redNotificationNo);
      map.put("cipherText", cipherText);
      map.put("systemOrig", systemOrig);
      map.put("receiveUserEmail", receiveUserEmail);
      map.put("purchaserBankNameAccount", purchaserBankNameAccount);
      map.put("authStatus", authStatus);
      map.put("redStatus", redStatus);
      map.put("redTime", redTime);
      map.put("redUserName", redUserName);
      map.put("retreatStatus", retreatStatus);
      map.put("retreatTime", retreatTime);
      map.put("veriStatus", veriStatus);
      map.put("veriUserName", veriUserName);
      map.put("freezeStatus", freezeStatus);
      map.put("freezeTime", freezeTime);
      map.put("freezeUserName", freezeUserName);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("invoiceOrig", invoiceOrig);
      map.put("sellerName", sellerName);
      map.put("recogStatus", recogStatus);
      map.put("sellerSyncStatus", sellerSyncStatus);
      map.put("pdfUrl", pdfUrl);
      map.put("bussinessNo", bussinessNo);
      map.put("checkCode", checkCode);
      map.put("purchaserNo", purchaserNo);
      map.put("matchStatus", matchStatus);
      map.put("matchTime", matchTime);
      map.put("matchAmount", matchAmount);
      map.put("recogDeductionImageUrl", recogDeductionImageUrl);
      map.put("recogInvoiceImageUrl", recogInvoiceImageUrl);
      map.put("recogChargeImageUrl", recogChargeImageUrl);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("invoiceId", invoiceId);
      map.put("lockStatus", lockStatus);
      map.put("authSyncStatus", authSyncStatus);
      map.put("authSyncTime", authSyncTime);
      map.put("checkStatus", checkStatus);
      map.put("checkingTime", checkingTime);
      map.put("checkFailureMessage", checkFailureMessage);
      map.put("checkPush", checkPush);
      map.put("invoiceOrigin", invoiceOrigin);
      map.put("invoiceColor", invoiceColor);
      map.put("redFlag", redFlag);
      map.put("coopIsPush", coopIsPush);
      map.put("taxInvoiceSource", taxInvoiceSource);
      map.put("allElectricInvoiceNo", allElectricInvoiceNo);
      map.put("xmlUrl", xmlUrl);
      map.put("ofdUrl", ofdUrl);
      map.put("imgUrl", imgUrl);
      map.put("qrCodeUrl", qrCodeUrl);
      map.put("cipherTextTwoCode", cipherTextTwoCode);
      map.put("imageUrl", imageUrl);

      return map;
  }

  public static InvoiceMain fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    InvoiceMain entity = new InvoiceMain();

    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperDrewDate((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaperDrewDate(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setPaperDrewDate(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankNameAccount")) {
      Object obj = map.get("purchaserBankNameAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redStatus")) {
      Object obj = map.get("redStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redTime")) {
      Object obj = map.get("redTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redUserName")) {
      Object obj = map.get("redUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatTime")) {
      Object obj = map.get("retreatTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRetreatTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriStatus")) {
      Object obj = map.get("veriStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVeriStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriUserName")) {
      Object obj = map.get("veriUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVeriUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezeStatus")) {
      Object obj = map.get("freezeStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFreezeStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezeTime")) {
      Object obj = map.get("freezeTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFreezeTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezeUserName")) {
      Object obj = map.get("freezeUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFreezeUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceOrig")) {
      Object obj = map.get("invoiceOrig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogStatus")) {
      Object obj = map.get("recogStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerSyncStatus")) {
      Object obj = map.get("sellerSyncStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerSyncStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPdfUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussinessNo")) {
      Object obj = map.get("bussinessNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBussinessNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchTime")) {
      Object obj = map.get("matchTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchAmount")) {
      Object obj = map.get("matchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("recogDeductionImageUrl")) {
      Object obj = map.get("recogDeductionImageUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogDeductionImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogInvoiceImageUrl")) {
      Object obj = map.get("recogInvoiceImageUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogInvoiceImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogChargeImageUrl")) {
      Object obj = map.get("recogChargeImageUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRecogChargeImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lockStatus")) {
      Object obj = map.get("lockStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLockStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authSyncStatus")) {
      Object obj = map.get("authSyncStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthSyncStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authSyncTime")) {
      Object obj = map.get("authSyncTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuthSyncTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkingTime")) {
      Object obj = map.get("checkingTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckingTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkFailureMessage")) {
      Object obj = map.get("checkFailureMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckFailureMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkPush")) {
      Object obj = map.get("checkPush");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCheckPush((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceOrigin")) {
      Object obj = map.get("invoiceOrigin");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceOrigin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redFlag")) {
      Object obj = map.get("redFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("coopIsPush")) {
      Object obj = map.get("coopIsPush");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCoopIsPush((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allElectricInvoiceNo")) {
      Object obj = map.get("allElectricInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xmlUrl")) {
      Object obj = map.get("xmlUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXmlUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ofdUrl")) {
      Object obj = map.get("ofdUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOfdUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imgUrl")) {
      Object obj = map.get("imgUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qrCodeUrl")) {
      Object obj = map.get("qrCodeUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQrCodeUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherTextTwoCode")) {
      Object obj = map.get("cipherTextTwoCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCipherTextTwoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imageUrl")) {
      Object obj = map.get("imageUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImageUrl((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTaxNo")) {
      Object obj = map.get("sellerTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddrTel")) {
      Object obj = map.get("sellerAddrTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddrTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankName")) {
      Object obj = map.get("sellerBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerBankAccount")) {
      Object obj = map.get("sellerBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paperDrewDate")) {
      Object obj = map.get("paperDrewDate");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setPaperDrewDate((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setPaperDrewDate(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setPaperDrewDate(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cashierName")) {
      Object obj = map.get("cashierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCashierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicerName")) {
      Object obj = map.get("invoicerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoicerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceNo")) {
      Object obj = map.get("originInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originInvoiceCode")) {
      Object obj = map.get("originInvoiceCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOriginInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redNotificationNo")) {
      Object obj = map.get("redNotificationNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedNotificationNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherText")) {
      Object obj = map.get("cipherText");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCipherText((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("systemOrig")) {
      Object obj = map.get("systemOrig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveUserEmail")) {
      Object obj = map.get("receiveUserEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setReceiveUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankNameAccount")) {
      Object obj = map.get("purchaserBankNameAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserBankNameAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authStatus")) {
      Object obj = map.get("authStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redStatus")) {
      Object obj = map.get("redStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redTime")) {
      Object obj = map.get("redTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redUserName")) {
      Object obj = map.get("redUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatStatus")) {
      Object obj = map.get("retreatStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRetreatStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("retreatTime")) {
      Object obj = map.get("retreatTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRetreatTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriStatus")) {
      Object obj = map.get("veriStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVeriStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("veriUserName")) {
      Object obj = map.get("veriUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setVeriUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezeStatus")) {
      Object obj = map.get("freezeStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFreezeStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezeTime")) {
      Object obj = map.get("freezeTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFreezeTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freezeUserName")) {
      Object obj = map.get("freezeUserName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFreezeUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceOrig")) {
      Object obj = map.get("invoiceOrig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogStatus")) {
      Object obj = map.get("recogStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRecogStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerSyncStatus")) {
      Object obj = map.get("sellerSyncStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerSyncStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pdfUrl")) {
      Object obj = map.get("pdfUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPdfUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bussinessNo")) {
      Object obj = map.get("bussinessNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBussinessNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkCode")) {
      Object obj = map.get("checkCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserNo")) {
      Object obj = map.get("purchaserNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMatchStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchTime")) {
      Object obj = map.get("matchTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setMatchTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchAmount")) {
      Object obj = map.get("matchAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
            this.setMatchAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
            this.setMatchAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
            this.setMatchAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setMatchAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
            this.setMatchAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("recogDeductionImageUrl")) {
      Object obj = map.get("recogDeductionImageUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRecogDeductionImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogInvoiceImageUrl")) {
      Object obj = map.get("recogInvoiceImageUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRecogInvoiceImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("recogChargeImageUrl")) {
      Object obj = map.get("recogChargeImageUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRecogChargeImageUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceId")) {
      Object obj = map.get("invoiceId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setInvoiceId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setInvoiceId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setInvoiceId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lockStatus")) {
      Object obj = map.get("lockStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setLockStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authSyncStatus")) {
      Object obj = map.get("authSyncStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthSyncStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authSyncTime")) {
      Object obj = map.get("authSyncTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAuthSyncTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkStatus")) {
      Object obj = map.get("checkStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkingTime")) {
      Object obj = map.get("checkingTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckingTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkFailureMessage")) {
      Object obj = map.get("checkFailureMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckFailureMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkPush")) {
      Object obj = map.get("checkPush");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCheckPush((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceOrigin")) {
      Object obj = map.get("invoiceOrigin");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceOrigin((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceColor")) {
      Object obj = map.get("invoiceColor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setInvoiceColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redFlag")) {
      Object obj = map.get("redFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRedFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("coopIsPush")) {
      Object obj = map.get("coopIsPush");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCoopIsPush((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxInvoiceSource")) {
      Object obj = map.get("taxInvoiceSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTaxInvoiceSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allElectricInvoiceNo")) {
      Object obj = map.get("allElectricInvoiceNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setAllElectricInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xmlUrl")) {
      Object obj = map.get("xmlUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setXmlUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ofdUrl")) {
      Object obj = map.get("ofdUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setOfdUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imgUrl")) {
      Object obj = map.get("imgUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setImgUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qrCodeUrl")) {
      Object obj = map.get("qrCodeUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setQrCodeUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cipherTextTwoCode")) {
      Object obj = map.get("cipherTextTwoCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCipherTextTwoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("imageUrl")) {
      Object obj = map.get("imageUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setImageUrl((String)obj);
        }
      } else{
      }
    }
  }
}
