package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 作废状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum AbandonStatus {

    _1("1", "正常"),
    _2("2", "待作废"),
    _3("3", "作废中"),
    _4("4", "作废成功"),
    _5("5", "作废失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AbandonStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AbandonStatus fromCode(String code) {
        return Stream.of(AbandonStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
