package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 接口业务类型
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum ApiBizType {

    _1("1", "业务单上传"),
    _2("2", "业务单上传反馈"),
    _3("3", "销项开票下发"),
    _4("4", "进项发票下发"),
    _5("5", "供应商入驻"),
    _6("6", "协同标识下发"),
    _7("7", "发票勾选"),
    _8("8", "勾选结果下发"),
    _9("9", "发票状态变更下发"),
    _10("10", "供应商发票锁定"),
    _11("11", "供应商发票解锁"),
    _12("12", "品类（大类）同步"),
    _13("13", "商品资料新增"),
    _14("14", "商品信息下发"),
    _15("15", "业务单作废"),
    _16("16", "进项发票付款状态变更"),
    _17("17", "商品审核状态变更"),
    _18("18", "品类与商品关系变更"),
    _19("19", "商品信息审核回写"),
    _20("20", "商品明细修改");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApiBizType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApiBizType fromCode(String code) {
        return Stream.of(ApiBizType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
