package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 调用状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum ApiRequestStatus {

    _1("1", "成功"),
    _2("2", "失败"),
    _0("0", "默认");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ApiRequestStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ApiRequestStatus fromCode(String code) {
        return Stream.of(ApiRequestStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
