package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 认证状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum AuthStatus {

    _1("1", "已认证"),
    _0("0", "待认证");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuthStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthStatus fromCode(String code) {
        return Stream.of(AuthStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
