package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 底账勾选状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum AuthSyncStatus {

    _1("1", "未勾选"),
    _2("2", "已勾选"),
    _3("3", "已勾选（签名确认）"),
    _4("4", "不可勾选");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuthSyncStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthSyncStatus fromCode(String code) {
        return Stream.of(AuthSyncStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
