package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 付款状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum BusinessStatus {

    _0("0", "未付款"),
    _1("1", "部分付款"),
    _2("2", "已付款");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessStatus fromCode(String code) {
        return Stream.of(BusinessStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
