package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务状态变更类型
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum BusinessType {

    _2("2", "付款状态变更");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BusinessType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessType fromCode(String code) {
        return Stream.of(BusinessType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
