package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 4.0-发票勾选状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum CheckStatus {

    _0("0", "默认"),
    _1("1", "不可勾选"),
    _2("2", "未勾选"),
    _3("3", "勾选中"),
    _4("4", "已勾选"),
    _5("5", "勾选失败"),
    _6("6", "抵扣异常"),
    _8("8", "已确认抵扣");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    CheckStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CheckStatus fromCode(String code) {
        return Stream.of(CheckStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
