package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 数据流向
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum DataFlow {

    _1("1", "客户=>属地"),
    _2("2", "属地=>平台"),
    _3("3", "平台=>属地"),
    _4("4", "属地=>客户");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataFlow(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataFlow fromCode(String code) {
        return Stream.of(DataFlow.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
