package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 冻结状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum FreezeStatus {

    _0("0", "未冻结"),
    _1("1", "已冻结");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    FreezeStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FreezeStatus fromCode(String code) {
        return Stream.of(FreezeStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
