package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 商品审核状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum GoodsApplyStatus {

    _0("0", "初始化"),
    _1("1", "待审核"),
    _2("2", "已驳回"),
    _3("3", "已审核"),
    _4("4", "自动审核");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    GoodsApplyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static GoodsApplyStatus fromCode(String code) {
        return Stream.of(GoodsApplyStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
