package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 审批类型
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum GoodsExamineType {

    _1("1", "商品资料修改审核"),
    _2("2", "商品明细修改审核");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    GoodsExamineType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static GoodsExamineType fromCode(String code) {
        return Stream.of(GoodsExamineType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
