package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 商品变更类型
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum GoodsModifyType {

    _0("0", "商品名称"),
    _1("1", "商品税编"),
    _("-", "-"),
    GOODS_NAME("GOODS_NAME", "商品名称"),
    GOODS_TAX_CODE("GOODS_TAX_CODE", "商品税编");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    GoodsModifyType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static GoodsModifyType fromCode(String code) {
        return Stream.of(GoodsModifyType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
