package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 影像来源
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum ImageFrom {

    _0("0", "识别"),
    _1("1", "详情页上传");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ImageFrom(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ImageFrom fromCode(String code) {
        return Stream.of(ImageFrom.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
