package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 锁定
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum InvoiceLock {

    _0("0", "正常"),
    _1("1", "锁定");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceLock(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceLock fromCode(String code) {
        return Stream.of(InvoiceLock.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
