package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单处理状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum ProcessStatus {

    _1("1", "导入成功"),
    _2("2", "已开票"),
    _3("3", "已删除"),
    _4("4", "已作废"),
    _5("5", "作废失败"),
    __2("-2", "待处理"),
    __1("-1", "导入失败"),
    _0("0", "已上传,未反馈"),
    _6("6", "开具失败");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ProcessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProcessStatus fromCode(String code) {
        return Stream.of(ProcessStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
