package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 是否有效
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum RuleStatus {

    _1("1", "有效"),
    _2("2", "删除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    RuleStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static RuleStatus fromCode(String code) {
        return Stream.of(RuleStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
