package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 业务单操作类型
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum SalesBillStatus {

    _0("0", "作废"),
    _1("1", "上传"),
    _9("9", "删除");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    SalesBillStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SalesBillStatus fromCode(String code) {
        return Stream.of(SalesBillStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
