package com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票状态
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public enum Status {

    _0("0", "作废"),
    _1("1", "正常"),
    _2("2", "红冲"),
    _3("3", "失控"),
    _4("4", "异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Status(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Status fromCode(String code) {
        return Stream.of(Status.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
