package com.xforceplus.ultraman.app.jcmeiyijia.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * supplier
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Supplier implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 注册来源
   */
  private String registerFrom;
  /**
   * 供应商公司名称
   */
  private String companyName;
  /**
   * 供应商公司税号
   */
  private String companyTaxNo;
  /**
   * 供应商账户的email地址 (email地址和电话至少填一个)
   */
  private String userEmail;
  /**
   * 供应商账户的手机号 (email地址和电话至少填一个)
   */
  private String userPhone;
  /**
   * 用户ID (调用方系统内的供应商账户的固定唯一ID)
   */
  private String userId;
  /**
   * 购方租户code
   */
  private String coopTenantCode;
  /**
   * 供应商编号
   */
  private String sellerNo;
  /**
   * 业务联系人姓名
   */
  private String businessName;
  /**
   * 业务联系人邮箱
   */
  private String businessEmail;
  /**
   * 业务联系人电话
   */
  private String businessPhone;
  /**
   * 业务联系人手机
   */
  private String businessTel;
  /**
   * 财务联系人姓名
   */
  private String financeName;
  /**
   * 财务联系人邮箱
   */
  private String financeEmail;
  /**
   * 财务联系人电话
   */
  private String financePhone;
  /**
   * 财务联系人手机
   */
  private String financeTel;
  /**
   * id
   */
  private Long id;
  /**
   * 租户id
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 协同标识：Y-协同，N-非协同
   */
  private String hasCoopFlag;
  /**
   * 处理结果
   */
  private String result;
  /**
   * 处理状态
   */
  private String status;
  /**
   * 供应商租户ID
   */
  private Long supplierTenantId;
  /**
   * 供应商租户代码
   */
  private String supplierTenantCode;
  /**
   * 供应商租户名称
   */
  private String supplierTenantName;
  /**
   * 公司ID
   */
  private Long companyId;
  /**
   * 回写状态
   */
  private String coopPush;
  /**
   * 回写报文
   */
  private String coopReq;
  /**
   * 服务起始时间
   */
  private String serviceStartTime;
  /**
   * 服务结束时间
   */
  private String serviceEndTime;


  public Map toOQSMap() {
      Map map = new HashMap();
      map.put("registerFrom", registerFrom);
      map.put("companyName", companyName);
      map.put("companyTaxNo", companyTaxNo);
      map.put("userEmail", userEmail);
      map.put("userPhone", userPhone);
      map.put("userId", userId);
      map.put("coopTenantCode", coopTenantCode);
      map.put("sellerNo", sellerNo);
      map.put("businessName", businessName);
      map.put("businessEmail", businessEmail);
      map.put("businessPhone", businessPhone);
      map.put("businessTel", businessTel);
      map.put("financeName", financeName);
      map.put("financeEmail", financeEmail);
      map.put("financePhone", financePhone);
      map.put("financeTel", financeTel);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("hasCoopFlag", hasCoopFlag);
      map.put("result", result);
      map.put("status", status);
      map.put("supplierTenantId", supplierTenantId);
      map.put("supplierTenantCode", supplierTenantCode);
      map.put("supplierTenantName", supplierTenantName);
      map.put("companyId", companyId);
      map.put("coopPush", coopPush);
      map.put("coopReq", coopReq);
      map.put("serviceStartTime", serviceStartTime);
      map.put("serviceEndTime", serviceEndTime);

      return map;
  }

  public static Supplier fromOQSMap(Map map) {
    if(map == null || map.isEmpty()) {
      return null;
    }
    Supplier entity = new Supplier();

    if(map.containsKey("registerFrom")) {
      Object obj = map.get("registerFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegisterFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userEmail")) {
      Object obj = map.get("userEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userPhone")) {
      Object obj = map.get("userPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userId")) {
      Object obj = map.get("userId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("coopTenantCode")) {
      Object obj = map.get("coopTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCoopTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessName")) {
      Object obj = map.get("businessName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessEmail")) {
      Object obj = map.get("businessEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessPhone")) {
      Object obj = map.get("businessPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessTel")) {
      Object obj = map.get("businessTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("financeName")) {
      Object obj = map.get("financeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFinanceName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("financeEmail")) {
      Object obj = map.get("financeEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFinanceEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("financePhone")) {
      Object obj = map.get("financePhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFinancePhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("financeTel")) {
      Object obj = map.get("financeTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFinanceTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hasCoopFlag")) {
      Object obj = map.get("hasCoopFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHasCoopFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("result")) {
      Object obj = map.get("result");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierTenantId")) {
      Object obj = map.get("supplierTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSupplierTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSupplierTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setSupplierTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("supplierTenantCode")) {
      Object obj = map.get("supplierTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierTenantName")) {
      Object obj = map.get("supplierTenantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyId")) {
      Object obj = map.get("companyId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompanyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("coopPush")) {
      Object obj = map.get("coopPush");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCoopPush((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("coopReq")) {
      Object obj = map.get("coopReq");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCoopReq((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceStartTime")) {
      Object obj = map.get("serviceStartTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setServiceStartTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceEndTime")) {
      Object obj = map.get("serviceEndTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setServiceEndTime((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("registerFrom")) {
      Object obj = map.get("registerFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setRegisterFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyName")) {
      Object obj = map.get("companyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyTaxNo")) {
      Object obj = map.get("companyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userEmail")) {
      Object obj = map.get("userEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUserEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userPhone")) {
      Object obj = map.get("userPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUserPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("userId")) {
      Object obj = map.get("userId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUserId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("coopTenantCode")) {
      Object obj = map.get("coopTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCoopTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerNo")) {
      Object obj = map.get("sellerNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSellerNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessName")) {
      Object obj = map.get("businessName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessEmail")) {
      Object obj = map.get("businessEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessPhone")) {
      Object obj = map.get("businessPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessTel")) {
      Object obj = map.get("businessTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setBusinessTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("financeName")) {
      Object obj = map.get("financeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFinanceName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("financeEmail")) {
      Object obj = map.get("financeEmail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFinanceEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("financePhone")) {
      Object obj = map.get("financePhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFinancePhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("financeTel")) {
      Object obj = map.get("financeTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setFinanceTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hasCoopFlag")) {
      Object obj = map.get("hasCoopFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setHasCoopFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("result")) {
      Object obj = map.get("result");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setResult((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierTenantId")) {
      Object obj = map.get("supplierTenantId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSupplierTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setSupplierTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setSupplierTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("supplierTenantCode")) {
      Object obj = map.get("supplierTenantCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSupplierTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierTenantName")) {
      Object obj = map.get("supplierTenantName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setSupplierTenantName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companyId")) {
      Object obj = map.get("companyId");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCompanyId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
            this.setCompanyId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCompanyId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("coopPush")) {
      Object obj = map.get("coopPush");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCoopPush((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("coopReq")) {
      Object obj = map.get("coopReq");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setCoopReq((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceStartTime")) {
      Object obj = map.get("serviceStartTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setServiceStartTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serviceEndTime")) {
      Object obj = map.get("serviceEndTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
            this.setServiceEndTime((String)obj);
        }
      } else{
      }
    }
  }
}
