package com.xforceplus.ultraman.app.jcmeiyijia.metadata.validator;

import com.xforceplus.ultraman.app.jcmeiyijia.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = null != AuthStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedStatus.class)) {
            isValid = null != RedStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RetreatStatus.class)) {
            isValid = null != RetreatStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RetreatStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VeriStatus.class)) {
            isValid = null != VeriStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, VeriStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FreezeStatus.class)) {
            isValid = null != FreezeStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FreezeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AbandonStatus.class)) {
            isValid = null != AbandonStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AbandonStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerSyncStatus.class)) {
            isValid = null != SellerSyncStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SellerSyncStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = null != Status.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageFrom.class)) {
            isValid = null != ImageFrom.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageStatus.class)) {
            isValid = null != ImageStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ImageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApiRequestStatus.class)) {
            isValid = null != ApiRequestStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApiRequestStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SalesBillStatus.class)) {
            isValid = null != SalesBillStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SalesBillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ProcessStatus.class)) {
            isValid = null != ProcessStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ProcessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApiBizType.class)) {
            isValid = null != ApiBizType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ApiBizType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataFlow.class)) {
            isValid = null != DataFlow.fromCode(value);
            if(!isValid) {
                unValidMsg(context, DataFlow.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceLock.class)) {
            isValid = null != InvoiceLock.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceLock.class.getSimpleName());
            }
        }
        if(clazz.equals(YesOrNot.class)) {
            isValid = null != YesOrNot.fromCode(value);
            if(!isValid) {
                unValidMsg(context, YesOrNot.class.getSimpleName());
            }
        }
        if(clazz.equals(LockStatus.class)) {
            isValid = null != LockStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, LockStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthSyncStatus.class)) {
            isValid = null != AuthSyncStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthSyncStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckStatus.class)) {
            isValid = null != CheckStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, CheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessType.class)) {
            isValid = null != BusinessType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessStatus.class)) {
            isValid = null != BusinessStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BusinessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthUse.class)) {
            isValid = null != AuthUse.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthUse.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsModifyType.class)) {
            isValid = null != GoodsModifyType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, GoodsModifyType.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsExamineType.class)) {
            isValid = null != GoodsExamineType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, GoodsExamineType.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsApplyStatus.class)) {
            isValid = null != GoodsApplyStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, GoodsApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RuleStatus.class)) {
            isValid = null != RuleStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RuleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = null != InvoiceColor.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(RedFlag.class)) {
            isValid = null != RedFlag.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = null != TaxInvoiceSource.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
