package com.xforceplus.ultraman.app.jcmeiyijia.metadata.validator;

import com.xforceplus.ultraman.app.jcmeiyijia.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.jcmeiyijia.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2023-10-24
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RetreatStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RetreatStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RetreatStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(VeriStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != VeriStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, VeriStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(FreezeStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != FreezeStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, FreezeStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AbandonStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AbandonStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AbandonStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SellerSyncStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SellerSyncStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SellerSyncStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Status.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageFrom.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageFrom.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageFrom.class.getSimpleName());
            }
        }
        if(clazz.equals(ImageStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ImageStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ImageStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApiRequestStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApiRequestStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApiRequestStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SalesBillStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SalesBillStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SalesBillStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ProcessStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ProcessStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ProcessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ApiBizType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ApiBizType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ApiBizType.class.getSimpleName());
            }
        }
        if(clazz.equals(DataFlow.class)) {
            isValid = vals.stream()
                    .filter(val -> null != DataFlow.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, DataFlow.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceLock.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceLock.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceLock.class.getSimpleName());
            }
        }
        if(clazz.equals(YesOrNot.class)) {
            isValid = vals.stream()
                    .filter(val -> null != YesOrNot.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, YesOrNot.class.getSimpleName());
            }
        }
        if(clazz.equals(LockStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != LockStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, LockStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthSyncStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthSyncStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthSyncStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(CheckStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != CheckStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, CheckStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessType.class.getSimpleName());
            }
        }
        if(clazz.equals(BusinessStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != BusinessStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, BusinessStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthUse.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthUse.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthUse.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsModifyType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != GoodsModifyType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, GoodsModifyType.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsExamineType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != GoodsExamineType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, GoodsExamineType.class.getSimpleName());
            }
        }
        if(clazz.equals(GoodsApplyStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != GoodsApplyStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, GoodsApplyStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RuleStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RuleStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RuleStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceColor.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceColor.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceColor.class.getSimpleName());
            }
        }
        if(clazz.equals(RedFlag.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedFlag.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedFlag.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSource.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxInvoiceSource.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSource.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
