package com.xforceplus.ultraman.app.jcmeiyijia.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmeiyijia.entity.ApiLogs;
import com.xforceplus.ultraman.app.jcmeiyijia.service.IApiLogsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-13
 */
@RestController
public class ApiLogsController {

  @Autowired
  private IApiLogsService apiLogsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param apiLogs ${table.comment}
   * @return
   */
  @GetMapping("/apilogss" )
  public XfR getApiLogss(XfPage page, ApiLogs apiLogs) {
    return XfR.ok(apiLogsServiceImpl.page(page, Wrappers.query(apiLogs)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/apilogss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(apiLogsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param apiLogs ${table.comment}
   * @return XfR
   */
  @PostMapping("/apilogss")
  public XfR save(@RequestBody ApiLogs apiLogs) {
     return XfR.ok(apiLogsServiceImpl.save(apiLogs));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param apiLogs ${table.comment}
   * @return XfR
   */
  @PutMapping("/apilogss/{id}")
  public XfR putUpdate(@RequestBody ApiLogs apiLogs,@PathVariable Long id) {
      apiLogs.setId(id);
      return XfR.ok(apiLogsServiceImpl.updateById(apiLogs));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param apiLogs ${table.comment}
   * @return XfR
   */
  @PatchMapping("/apilogss/{id}")
  public XfR patchUpdate(@RequestBody ApiLogs apiLogs,@PathVariable Long id) {
      ApiLogs upapiLogs = apiLogsServiceImpl.getById(id);
      if(upapiLogs != null){
        upapiLogs = ObjectCopyUtils.copyProperties(apiLogs,upapiLogs,true);
      }
      return XfR.ok(apiLogsServiceImpl.updateById(upapiLogs));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/apilogss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(apiLogsServiceImpl.removeById(id));
  }

  @PostMapping("/apilogss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "api_logs");
     params.put("request", condition);

     return XfR.ok(apiLogsServiceImpl.querys(params));
  }

}
