package com.xforceplus.ultraman.app.jcmeiyijia.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.jcmeiyijia.entity.GoodsExamine;
import com.xforceplus.ultraman.app.jcmeiyijia.service.IGoodsExamineService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-09-13
 */
@RestController
public class GoodsExamineController {

  @Autowired
  private IGoodsExamineService goodsExamineServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param goodsExamine ${table.comment}
   * @return
   */
  @GetMapping("/goodsexamines" )
  public XfR getGoodsExamines(XfPage page, GoodsExamine goodsExamine) {
    return XfR.ok(goodsExamineServiceImpl.page(page, Wrappers.query(goodsExamine)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/goodsexamines/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(goodsExamineServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param goodsExamine ${table.comment}
   * @return XfR
   */
  @PostMapping("/goodsexamines")
  public XfR save(@RequestBody GoodsExamine goodsExamine) {
     return XfR.ok(goodsExamineServiceImpl.save(goodsExamine));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param goodsExamine ${table.comment}
   * @return XfR
   */
  @PutMapping("/goodsexamines/{id}")
  public XfR putUpdate(@RequestBody GoodsExamine goodsExamine,@PathVariable Long id) {
      goodsExamine.setId(id);
      return XfR.ok(goodsExamineServiceImpl.updateById(goodsExamine));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param goodsExamine ${table.comment}
   * @return XfR
   */
  @PatchMapping("/goodsexamines/{id}")
  public XfR patchUpdate(@RequestBody GoodsExamine goodsExamine,@PathVariable Long id) {
      GoodsExamine upgoodsExamine = goodsExamineServiceImpl.getById(id);
      if(upgoodsExamine != null){
        upgoodsExamine = ObjectCopyUtils.copyProperties(goodsExamine,upgoodsExamine,true);
      }
      return XfR.ok(goodsExamineServiceImpl.updateById(upgoodsExamine));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/goodsexamines/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(goodsExamineServiceImpl.removeById(id));
  }

  @PostMapping("/goodsexamines/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "goods_examine");
     params.put("request", condition);

     return XfR.ok(goodsExamineServiceImpl.querys(params));
  }

}
