package com.xforceplus.ultraman.app.jcmeiyijia.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcmeiyijia.entity.BizRule;
import com.xforceplus.ultraman.app.jcmeiyijia.service.IBizRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 业务规则管理前端控制器
 *
 * @author ultraman
 * @date 2022-11-21
 */
@RestController
public class BizRuleController {

  @Autowired
  private IBizRuleService bizRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizRule 业务规则管理
   * @return
   */
  @GetMapping("/bizrules" )
  public XfR getBizRules(XfPage page, BizRule bizRule) {
    return XfR.ok(bizRuleServiceImpl.page(page, Wrappers.query(bizRule)));
  }

  /**
   * 通过id查询业务规则管理
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizRuleServiceImpl.getById(id));
  }

  /**
   * 新增业务规则管理
   * @param bizRule 业务规则管理
   * @return XfR
   */
  @PostMapping("/bizrules")
  public XfR save(@RequestBody BizRule bizRule) {
     return XfR.ok(bizRuleServiceImpl.save(bizRule));
  }

  /**
   * 修改-传入修改后的全部数据业务规则管理
   * @param bizRule 业务规则管理
   * @return XfR
   */
  @PutMapping("/bizrules/{id}")
  public XfR putUpdate(@RequestBody BizRule bizRule,@PathVariable Long id) {
      bizRule.setId(id);
      return XfR.ok(bizRuleServiceImpl.updateById(bizRule));
  }

  /**
   * 修改-传入修改的数据业务规则管理
   * @param bizRule 业务规则管理
   * @return XfR
   */
  @PatchMapping("/bizrules/{id}")
  public XfR patchUpdate(@RequestBody BizRule bizRule,@PathVariable Long id) {
      BizRule upbizRule = bizRuleServiceImpl.getById(id);
      if(upbizRule != null){
        upbizRule = ObjectCopyUtils.copyProperties(bizRule,upbizRule,true);
      }
      return XfR.ok(bizRuleServiceImpl.updateById(upbizRule));
  }

  /**
   * 通过id删除业务规则管理
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizRuleServiceImpl.removeById(id));
  }

  @PostMapping("/bizrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_rule");
     params.put("request", condition);

     return XfR.ok(bizRuleServiceImpl.querys(params));
  }

}
