package com.xforceplus.ultraman.app.jcmetro.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-05-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BizOrderMain implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 单据号
   */
  @TableField("bizOrderNo")
  private String bizOrderNo;

  /**
   * x
   */
  @TableField("xFlag")
  private String xFlag;

  /**
   * 帐扣/非帐扣
   */
  @TableField("deductionFlag")
  private String deductionFlag;

  /**
   * 供应商号
   */
  @TableField("supplierCode")
  private String supplierCode;

  /**
   * 供应商名称
   */
  @TableField("supplierName")
  private String supplierName;

  /**
   * 供应商税号
   */
  @TableField("supplierTaxNo")
  private String supplierTaxNo;

  /**
   * 货物名称
   */
  @TableField("itemName")
  private String itemName;

  /**
   * 返利合同号
   */
  @TableField("rebetContract")
  private String rebetContract;

  /**
   * 原BS 利润中心
   */
  @TableField("originalProfitCenter")
  private String originalProfitCenter;

  /**
   * 原BS 返利合同
   */
  @TableField("originalRebetContract")
  private String originalRebetContract;

  /**
   * 返利单不含税金额
   */
  @TableField("rebetAmountWithoutTax")
  private BigDecimal rebetAmountWithoutTax;

  /**
   * 返利单税额
   */
  @TableField("rebetTaxAmount")
  private BigDecimal rebetTaxAmount;

  /**
   * 返利单含税金额
   */
  @TableField("rebetAmountWithTax")
  private BigDecimal rebetAmountWithTax;

  /**
   * 返利单税率
   */
  @TableField("rebetTaxRate")
  private BigDecimal rebetTaxRate;

  /**
   * 唯一流水号
   */
  @TableField("serialNo")
  private String serialNo;

  /**
   * 购方店号
   */
  @TableField("storeNo")
  private String storeNo;

  /**
   * 拓展字段1
   */
  private String ext1;

  /**
   * 拓展字段2
   */
  private String ext2;

  /**
   * 拓展字段3
   */
  private String ext3;

  /**
   * 拓展字段4
   */
  private String ext4;

  /**
   * 拓展字段5
   */
  private String ext5;

  /**
   * 拓展字段6
   */
  private String ext6;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 转大仓店号
   */
  @TableField("zdcStoreNo")
  private String zdcStoreNo;

  /**
   * 转大仓税号
   */
  @TableField("zdcTaxNo")
  private String zdcTaxNo;

  /**
   * 转大仓公司名称
   */
  @TableField("zdcTaxName")
  private String zdcTaxName;

  /**
   * F/NF
   */
  @TableField("fNfFlag")
  private String fNfFlag;

  /**
   * 拓展字段7
   */
  private String ext7;

  /**
   * 拓展字段8
   */
  private String ext8;

  /**
   * 拓展字段9
   */
  private String ext9;

  /**
   * 拓展字段10
   */
  private String ext10;

  /**
   * 返利单号
   */
  @TableField("rebetNo")
  private String rebetNo;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bizOrderNo", bizOrderNo);
      map.put("xFlag", xFlag);
      map.put("deductionFlag", deductionFlag);
      map.put("supplierCode", supplierCode);
      map.put("supplierName", supplierName);
      map.put("supplierTaxNo", supplierTaxNo);
      map.put("itemName", itemName);
      map.put("rebetContract", rebetContract);
      map.put("originalProfitCenter", originalProfitCenter);
      map.put("originalRebetContract", originalRebetContract);
      map.put("rebetAmountWithoutTax", rebetAmountWithoutTax);
      map.put("rebetTaxAmount", rebetTaxAmount);
      map.put("rebetAmountWithTax", rebetAmountWithTax);
      map.put("rebetTaxRate", rebetTaxRate);
      map.put("serialNo", serialNo);
      map.put("storeNo", storeNo);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("zdcStoreNo", zdcStoreNo);
      map.put("zdcTaxNo", zdcTaxNo);
      map.put("zdcTaxName", zdcTaxName);
      map.put("fNfFlag", fNfFlag);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("rebetNo", rebetNo);

      return map;
  }

  public static BizOrderMain fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BizOrderMain entity = new BizOrderMain();
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xFlag")) {
      Object obj = map.get("xFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deductionFlag")) {
      Object obj = map.get("deductionFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeductionFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierTaxNo")) {
      Object obj = map.get("supplierTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rebetContract")) {
      Object obj = map.get("rebetContract");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRebetContract((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalProfitCenter")) {
      Object obj = map.get("originalProfitCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalProfitCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalRebetContract")) {
      Object obj = map.get("originalRebetContract");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalRebetContract((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rebetAmountWithoutTax")) {
      Object obj = map.get("rebetAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebetAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebetAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebetAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRebetAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebetAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebetTaxAmount")) {
      Object obj = map.get("rebetTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebetTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebetTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebetTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRebetTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebetTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebetAmountWithTax")) {
      Object obj = map.get("rebetAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebetAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebetAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebetAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRebetAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebetAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebetTaxRate")) {
      Object obj = map.get("rebetTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebetTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebetTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebetTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRebetTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebetTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zdcStoreNo")) {
      Object obj = map.get("zdcStoreNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZdcStoreNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zdcTaxNo")) {
      Object obj = map.get("zdcTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZdcTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zdcTaxName")) {
      Object obj = map.get("zdcTaxName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZdcTaxName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fNfFlag")) {
      Object obj = map.get("fNfFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFNfFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rebetNo")) {
      Object obj = map.get("rebetNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRebetNo((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("xFlag")) {
      Object obj = map.get("xFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setXFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deductionFlag")) {
      Object obj = map.get("deductionFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeductionFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierTaxNo")) {
      Object obj = map.get("supplierTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rebetContract")) {
      Object obj = map.get("rebetContract");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRebetContract((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalProfitCenter")) {
      Object obj = map.get("originalProfitCenter");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalProfitCenter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalRebetContract")) {
      Object obj = map.get("originalRebetContract");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalRebetContract((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rebetAmountWithoutTax")) {
      Object obj = map.get("rebetAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebetAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebetAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebetAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRebetAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebetAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rebetTaxAmount")) {
      Object obj = map.get("rebetTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebetTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebetTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebetTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRebetTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebetTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rebetAmountWithTax")) {
      Object obj = map.get("rebetAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebetAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebetAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebetAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRebetAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebetAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rebetTaxRate")) {
      Object obj = map.get("rebetTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebetTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebetTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebetTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRebetTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebetTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSerialNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zdcStoreNo")) {
      Object obj = map.get("zdcStoreNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZdcStoreNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zdcTaxNo")) {
      Object obj = map.get("zdcTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZdcTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zdcTaxName")) {
      Object obj = map.get("zdcTaxName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZdcTaxName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fNfFlag")) {
      Object obj = map.get("fNfFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFNfFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rebetNo")) {
      Object obj = map.get("rebetNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRebetNo((String)obj);
        }
      } else {
      }
    }
  }
}
