package com.xforceplus.ultraman.app.jcmetro.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-05-30
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BizOrderRedLetter implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 业务单号
   */
  @TableField("bizOrderNo")
  private String bizOrderNo;

  /**
   * 供应商号
   */
  @TableField("supplierCode")
  private String supplierCode;

  /**
   * 供应商名称
   */
  @TableField("supplierName")
  private String supplierName;

  /**
   * 供应商税号
   */
  @TableField("supplierTaxNo")
  private String supplierTaxNo;

  /**
   * F/NF
   */
  @TableField("fNfFlag")
  private String fNfFlag;

  /**
   * 货物名称
   */
  @TableField("itemName")
  private String itemName;

  /**
   * 返利合同号
   */
  @TableField("rebetContract")
  private String rebetContract;

  /**
   * 原BS利润中心
   */
  @TableField("originalProfitCenter")
  private String originalProfitCenter;

  /**
   * 原BS返利合同
   */
  @TableField("originalRebetContract")
  private String originalRebetContract;

  /**
   * 原BS Net
   */
  @TableField("rebetAmountWithoutTax")
  private BigDecimal rebetAmountWithoutTax;

  /**
   * 原BS VAT
   */
  @TableField("rebetTaxAmount")
  private BigDecimal rebetTaxAmount;

  /**
   * 原BS Gross
   */
  @TableField("rebetAmountWithTax")
  private BigDecimal rebetAmountWithTax;

  /**
   * 原BS 税率
   */
  @TableField("rebetTaxRate")
  private BigDecimal rebetTaxRate;

  /**
   * 新BS Net
   */
  @TableField("newBsAmountWithoutTax")
  private BigDecimal newBsAmountWithoutTax;

  /**
   * 新BS VAT
   */
  @TableField("newBsTaxAmount")
  private BigDecimal newBsTaxAmount;

  /**
   * 新BS Gross
   */
  @TableField("newBsAmountWithTax")
  private BigDecimal newBsAmountWithTax;

  /**
   * 红字发票信息表号
   */
  @TableField("redLetterNumber")
  private String redLetterNumber;

  /**
   * 唯一流水号
   */
  @TableField("serialNo")
  private String serialNo;

  /**
   * 红字通知单利润中心
   */
  @TableField("storeNo")
  private String storeNo;

  /**
   * 红字通知单Net
   */
  @TableField("redAmountWithoutTax")
  private BigDecimal redAmountWithoutTax;

  /**
   * 红字通知单VAT
   */
  @TableField("redTaxAmount")
  private BigDecimal redTaxAmount;

  /**
   * 红字通知单Gross
   */
  @TableField("redAmountWithTax")
  private BigDecimal redAmountWithTax;

  /**
   * 红字通知单税率
   */
  @TableField("redTaxRate")
  private BigDecimal redTaxRate;

  /**
   * 红字通知单生成日期
   */
  @TableField("redPaperDrewDate")
  private String redPaperDrewDate;

  /**
   * 红字通知单状态值
   */
  @TableField("redStatus")
  private String redStatus;

  /**
   * 拓展字段1
   */
  private String ext1;

  /**
   * 拓展字段2
   */
  private String ext2;

  /**
   * 拓展字段3
   */
  private String ext3;

  /**
   * 拓展字段4
   */
  private String ext4;

  /**
   * 拓展字段5
   */
  private String ext5;

  /**
   * 拓展字段6
   */
  private String ext6;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 返利单号
   */
  @TableField("rebetNo")
  private String rebetNo;

  /**
   * 批次号
   */
  @TableField("batchNo")
  private String batchNo;

  /**
   * 批次匹配状态
   */
  @TableField("matchStatus")
  private String matchStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("bizOrderNo", bizOrderNo);
      map.put("supplierCode", supplierCode);
      map.put("supplierName", supplierName);
      map.put("supplierTaxNo", supplierTaxNo);
      map.put("fNfFlag", fNfFlag);
      map.put("itemName", itemName);
      map.put("rebetContract", rebetContract);
      map.put("originalProfitCenter", originalProfitCenter);
      map.put("originalRebetContract", originalRebetContract);
      map.put("rebetAmountWithoutTax", rebetAmountWithoutTax);
      map.put("rebetTaxAmount", rebetTaxAmount);
      map.put("rebetAmountWithTax", rebetAmountWithTax);
      map.put("rebetTaxRate", rebetTaxRate);
      map.put("newBsAmountWithoutTax", newBsAmountWithoutTax);
      map.put("newBsTaxAmount", newBsTaxAmount);
      map.put("newBsAmountWithTax", newBsAmountWithTax);
      map.put("redLetterNumber", redLetterNumber);
      map.put("serialNo", serialNo);
      map.put("storeNo", storeNo);
      map.put("redAmountWithoutTax", redAmountWithoutTax);
      map.put("redTaxAmount", redTaxAmount);
      map.put("redAmountWithTax", redAmountWithTax);
      map.put("redTaxRate", redTaxRate);
      map.put("redPaperDrewDate", redPaperDrewDate);
      map.put("redStatus", redStatus);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("rebetNo", rebetNo);
      map.put("batchNo", batchNo);
      map.put("matchStatus", matchStatus);

      return map;
  }

  public static BizOrderRedLetter fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BizOrderRedLetter entity = new BizOrderRedLetter();
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBizOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierTaxNo")) {
      Object obj = map.get("supplierTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("fNfFlag")) {
      Object obj = map.get("fNfFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFNfFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rebetContract")) {
      Object obj = map.get("rebetContract");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRebetContract((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalProfitCenter")) {
      Object obj = map.get("originalProfitCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalProfitCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalRebetContract")) {
      Object obj = map.get("originalRebetContract");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginalRebetContract((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rebetAmountWithoutTax")) {
      Object obj = map.get("rebetAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebetAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebetAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebetAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRebetAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebetAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebetTaxAmount")) {
      Object obj = map.get("rebetTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebetTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebetTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebetTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRebetTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebetTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebetAmountWithTax")) {
      Object obj = map.get("rebetAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebetAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebetAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebetAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRebetAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebetAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("rebetTaxRate")) {
      Object obj = map.get("rebetTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRebetTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRebetTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRebetTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRebetTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRebetTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("newBsAmountWithoutTax")) {
      Object obj = map.get("newBsAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNewBsAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNewBsAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNewBsAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNewBsAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNewBsAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("newBsTaxAmount")) {
      Object obj = map.get("newBsTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNewBsTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNewBsTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNewBsTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNewBsTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNewBsTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("newBsAmountWithTax")) {
      Object obj = map.get("newBsAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNewBsAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNewBsAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNewBsAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNewBsAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNewBsAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedLetterNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSerialNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redAmountWithoutTax")) {
      Object obj = map.get("redAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRedAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRedAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRedAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRedAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redTaxAmount")) {
      Object obj = map.get("redTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRedTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRedTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRedTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRedTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redAmountWithTax")) {
      Object obj = map.get("redAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRedAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRedAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRedAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRedAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redTaxRate")) {
      Object obj = map.get("redTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRedTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRedTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRedTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRedTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRedTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("redPaperDrewDate")) {
      Object obj = map.get("redPaperDrewDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedPaperDrewDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redStatus")) {
      Object obj = map.get("redStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRedStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rebetNo")) {
      Object obj = map.get("rebetNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRebetNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatchStatus((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("bizOrderNo")) {
      Object obj = map.get("bizOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBizOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierTaxNo")) {
      Object obj = map.get("supplierTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("fNfFlag")) {
      Object obj = map.get("fNfFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFNfFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemName")) {
      Object obj = map.get("itemName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rebetContract")) {
      Object obj = map.get("rebetContract");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRebetContract((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalProfitCenter")) {
      Object obj = map.get("originalProfitCenter");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalProfitCenter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalRebetContract")) {
      Object obj = map.get("originalRebetContract");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalRebetContract((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rebetAmountWithoutTax")) {
      Object obj = map.get("rebetAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebetAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebetAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebetAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRebetAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebetAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rebetTaxAmount")) {
      Object obj = map.get("rebetTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebetTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebetTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebetTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRebetTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebetTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rebetAmountWithTax")) {
      Object obj = map.get("rebetAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebetAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebetAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebetAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRebetAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebetAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("rebetTaxRate")) {
      Object obj = map.get("rebetTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRebetTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRebetTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRebetTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRebetTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRebetTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("newBsAmountWithoutTax")) {
      Object obj = map.get("newBsAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setNewBsAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setNewBsAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setNewBsAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setNewBsAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setNewBsAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("newBsTaxAmount")) {
      Object obj = map.get("newBsTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setNewBsTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setNewBsTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setNewBsTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setNewBsTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setNewBsTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("newBsAmountWithTax")) {
      Object obj = map.get("newBsAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setNewBsAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setNewBsAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setNewBsAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setNewBsAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setNewBsAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("redLetterNumber")) {
      Object obj = map.get("redLetterNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedLetterNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("serialNo")) {
      Object obj = map.get("serialNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSerialNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeNo")) {
      Object obj = map.get("storeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redAmountWithoutTax")) {
      Object obj = map.get("redAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRedAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRedAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRedAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRedAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRedAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("redTaxAmount")) {
      Object obj = map.get("redTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRedTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRedTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRedTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRedTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRedTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("redAmountWithTax")) {
      Object obj = map.get("redAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRedAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRedAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRedAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRedAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRedAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("redTaxRate")) {
      Object obj = map.get("redTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRedTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRedTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRedTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRedTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRedTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("redPaperDrewDate")) {
      Object obj = map.get("redPaperDrewDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedPaperDrewDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redStatus")) {
      Object obj = map.get("redStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rebetNo")) {
      Object obj = map.get("rebetNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRebetNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("matchStatus")) {
      Object obj = map.get("matchStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatchStatus((String)obj);
        }
      } else {
      }
    }
  }
}
