/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.app.jcmetro.metadata.validator;

import com.xforceplus.ultraman.app.jcmetro.metadata.dict.AvailableFlag;
import com.xforceplus.ultraman.app.jcmetro.metadata.dict.ConvertTitleFlag;
import com.xforceplus.ultraman.app.jcmetro.metadata.dict.FlowStatus;
import com.xforceplus.ultraman.app.jcmetro.metadata.dict.RebetRedFlag;
import com.xforceplus.ultraman.app.jcmetro.metadata.dict.SnapshotFormat;
import com.xforceplus.ultraman.app.jcmetro.metadata.validator.annotation.CheckUltramanEnums;
import java.util.Arrays;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class UltramanEnumsConstraintValidator
implements ConstraintValidator<CheckUltramanEnums, String> {
    private final String MSG_FORMAT = "value must be formed from codes of enum %s";
    Class clazz;

    public void initialize(CheckUltramanEnums constraintAnnotation) {
        this.clazz = constraintAnnotation.value();
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (null == value || value.length() == 0) {
            return true;
        }
        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));
        if (this.clazz.equals(FlowStatus.class)) {
            boolean bl = isValid = vals.stream().filter(val -> null != FlowStatus.fromCode(val)).count() == (long)vals.size();
            if (!isValid) {
                this.unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if (this.clazz.equals(SnapshotFormat.class)) {
            boolean bl = isValid = vals.stream().filter(val -> null != SnapshotFormat.fromCode(val)).count() == (long)vals.size();
            if (!isValid) {
                this.unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if (this.clazz.equals(RebetRedFlag.class)) {
            boolean bl = isValid = vals.stream().filter(val -> null != RebetRedFlag.fromCode(val)).count() == (long)vals.size();
            if (!isValid) {
                this.unValidMsg(context, RebetRedFlag.class.getSimpleName());
            }
        }
        if (this.clazz.equals(ConvertTitleFlag.class)) {
            boolean bl = isValid = vals.stream().filter(val -> null != ConvertTitleFlag.fromCode(val)).count() == (long)vals.size();
            if (!isValid) {
                this.unValidMsg(context, ConvertTitleFlag.class.getSimpleName());
            }
        }
        if (this.clazz.equals(AvailableFlag.class)) {
            boolean bl = isValid = vals.stream().filter(val -> null != AvailableFlag.fromCode(val)).count() == (long)vals.size();
            if (!isValid) {
                this.unValidMsg(context, AvailableFlag.class.getSimpleName());
            }
        }
        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(String.format("value must be formed from codes of enum %s", enumName)).addConstraintViolation();
    }
}

