package com.xforceplus.ultraman.app.jcmetro.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcmetro.entity.BizOrderRedLetter;
import com.xforceplus.ultraman.app.jcmetro.service.IBizOrderRedLetterService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-06-18
 */
@RestController
public class BizOrderRedLetterController {

  @Autowired
  private IBizOrderRedLetterService bizOrderRedLetterServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bizOrderRedLetter ${table.comment}
   * @return
   */
  @GetMapping("/bizorderredletters" )
  public XfR getBizOrderRedLetters(XfPage page, BizOrderRedLetter bizOrderRedLetter) {
    return XfR.ok(bizOrderRedLetterServiceImpl.page(page, Wrappers.query(bizOrderRedLetter)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bizorderredletters/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bizOrderRedLetterServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bizOrderRedLetter ${table.comment}
   * @return XfR
   */
  @PostMapping("/bizorderredletters")
  public XfR save(@RequestBody BizOrderRedLetter bizOrderRedLetter) {
     return XfR.ok(bizOrderRedLetterServiceImpl.save(bizOrderRedLetter));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bizOrderRedLetter ${table.comment}
   * @return XfR
   */
  @PutMapping("/bizorderredletters/{id}")
  public XfR putUpdate(@RequestBody BizOrderRedLetter bizOrderRedLetter,@PathVariable Long id) {
      bizOrderRedLetter.setId(id);
      return XfR.ok(bizOrderRedLetterServiceImpl.updateById(bizOrderRedLetter));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bizOrderRedLetter ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bizorderredletters/{id}")
  public XfR patchUpdate(@RequestBody BizOrderRedLetter bizOrderRedLetter,@PathVariable Long id) {
      BizOrderRedLetter upbizOrderRedLetter = bizOrderRedLetterServiceImpl.getById(id);
      if(upbizOrderRedLetter != null){
        upbizOrderRedLetter = ObjectCopyUtils.copyProperties(bizOrderRedLetter,upbizOrderRedLetter,true);
      }
      return XfR.ok(bizOrderRedLetterServiceImpl.updateById(upbizOrderRedLetter));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bizorderredletters/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bizOrderRedLetterServiceImpl.removeById(id));
  }

  @PostMapping("/bizorderredletters/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "biz_order_red_letter");
     params.put("request", condition);

     return XfR.ok(bizOrderRedLetterServiceImpl.querys(params));
  }

}
