package com.xforceplus.ultraman.app.jcmetro.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcmetro.entity.StoreToDc;
import com.xforceplus.ultraman.app.jcmetro.service.IStoreToDcService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-06-18
 */
@RestController
public class StoreToDcController {

  @Autowired
  private IStoreToDcService storeToDcServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param storeToDc ${table.comment}
   * @return
   */
  @GetMapping("/storetodcs" )
  public XfR getStoreToDcs(XfPage page, StoreToDc storeToDc) {
    return XfR.ok(storeToDcServiceImpl.page(page, Wrappers.query(storeToDc)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/storetodcs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(storeToDcServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param storeToDc ${table.comment}
   * @return XfR
   */
  @PostMapping("/storetodcs")
  public XfR save(@RequestBody StoreToDc storeToDc) {
     return XfR.ok(storeToDcServiceImpl.save(storeToDc));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param storeToDc ${table.comment}
   * @return XfR
   */
  @PutMapping("/storetodcs/{id}")
  public XfR putUpdate(@RequestBody StoreToDc storeToDc,@PathVariable Long id) {
      storeToDc.setId(id);
      return XfR.ok(storeToDcServiceImpl.updateById(storeToDc));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param storeToDc ${table.comment}
   * @return XfR
   */
  @PatchMapping("/storetodcs/{id}")
  public XfR patchUpdate(@RequestBody StoreToDc storeToDc,@PathVariable Long id) {
      StoreToDc upstoreToDc = storeToDcServiceImpl.getById(id);
      if(upstoreToDc != null){
        upstoreToDc = ObjectCopyUtils.copyProperties(storeToDc,upstoreToDc,true);
      }
      return XfR.ok(storeToDcServiceImpl.updateById(upstoreToDc));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/storetodcs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(storeToDcServiceImpl.removeById(id));
  }

  @PostMapping("/storetodcs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "store_to_dc");
     params.put("request", condition);

     return XfR.ok(storeToDcServiceImpl.querys(params));
  }

}
